package com.jfb.recruit.service.auth;

import com.jfb.recruit.bean.auth.SelfUserEntity;
import com.jfb.recruit.service.PersonService;
import com.jfb.recruit.service.UserService;
import data.recruit.Person;
import data.user.User;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.Objects;

@Slf4j
@Component
public class SelfUserDetailsService implements UserDetailsService {

    @Autowired
    private UserService userService;

    @Autowired
    private PersonService personService;

    /**
     * 查询用户信息
     * @param username
     * @return
     * @author wml
     * @date 2020/4/4
     **/
    @Override
    public SelfUserEntity loadUserByUsername(String username) throws UsernameNotFoundException {
        HttpServletRequest req = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        String wxType = req.getParameter("wxType");
        SelfUserEntity sysUserEntity = new SelfUserEntity();

        if(StringUtils.isNotBlank(wxType)&&wxType.equals("wx")){
            Person user = personService.getDetailsByLoginOpenId(username);

            if (user == null) {
                throw new UsernameNotFoundException("账号不存在");
            }

            sysUserEntity.setUsername(user.getOpenId());
            sysUserEntity.setPassword("");
            sysUserEntity.setUserId(user.getId());
            sysUserEntity.setBaseCode(user.getBaseCode()== null ? "" : user.getBaseCode());
            sysUserEntity.setName(user.getName());
            sysUserEntity.setOpenId(user.getOpenId());
        }else {
            User user = userService.getDetailsByLoginAccount(username);

            if (user == null) {
                throw new UsernameNotFoundException("账号不存在");
            }
            Object state = user.getState();
            if (!Objects.equals(state, "normal")) {
                // 账号被禁用
                log.error("登录失败, 账号被禁用, jsonObject={}", user);
                throw new LockedException("账号被禁用");
            }

            sysUserEntity.setUsername(user.getAccount());
            sysUserEntity.setPassword(user.getPassword());
            sysUserEntity.setUserId(user.getId());
            sysUserEntity.setBaseCode(user.getBaseCode()== null ? "" : user.getBaseCode());
            sysUserEntity.setName(user.getName());
            sysUserEntity.setType(user.getType());
        }
        return sysUserEntity;
    }


}