package util.qrCode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

/**
 * @Description: (二维码) *
 * @author：wangmenglong *
 * @date：2015-10-29 下午05:27:13
 */

public class ZXingCode {
    private static final int QRCOLOR = 0xFF000000; //默认是黑色
    private static final int BGWHITE = 0xFFFFFFFF; //背景颜色

    public static void main(String[] args) throws WriterException {
        try {
            String base64 = "data:image/jpeg;base64,"+getLogoQRCode("{\"pro_id\":\"1\",\"action\":\"interview\",\"base_code\":\"001\"}", null, "测试项目（接站二维码）");
            System.out.println(base64);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 生成带logo的二维码图片 * *
     */
    public static String getLogoQRCode(String qrUrl, HttpServletRequest request, String productName) {
        // String filePath = request.getSession().getServletContext().getRealPath("/") + "resources/images/logoImages/llhlogo.png";
        //filePath是二维码logo的路径，但是实际中我们是放在项目的某个路径下面的，所以路径用上面的，把下面的注释就好
        //String filePath = "C:/Users/Administrator/Desktop/logo.png";

        //去掉data:image/png;base64,因为下面base64ToBufferedImage方法从base64转换成BufferedImage的时候这个会报错不识别
        //String base64Url="data:image/png;base64,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";
        //String base64Url="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";
        String base64Url="iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAIAAADajyQQAAAACXBIWXMAAAsSAAALEgHS3X78AAAEf0lEQVRoge2bT0wTWRzHn01DKXRU2GLLkDgSmgzNGimhtYlpVTBhywU3RL2IcZVk1U1c9WLUGA/in42X9c9B3WTVxF6ErBEuwB6aQPWwS42tUUsTDJakhWoD6tRCFYMhQ2otnXnT2t/g4HyO7a+/97597/3e7837zbLZ2VkEjMs9EhiOsm1YakmzqQK6RYQQrDCPN3TynGsswqR+SBu07ccbaIMWrl1YYS73yJGTPRm/0hQX3Lj8M6g2KGHhcWb73juxd++5DMp1RG/HLoimWRRAfp2dPh5VCKGxCNPVMwTUOqAwl3sEa9PdKzVhTCyRFjAy4vGGIVpnARGWDO6LCIgwUr98qQojNMUFWDOziYRonQUqeDTYK7E29Ta8Tc5ACTuwZz2/gaa4YGtTNVDrgMJIPXH6WAOPQfvxLYRGBdQ6QkgJ55odkAtX7qft1JrigkvnmqBTYfDsnoklunqGPN4wE0sQGlW9rbLBXgk6VixiHFsWBag1JguDQhYmNZasMPw+5vGG2g51ATXv6/8t7ZO2Q/fycpyRp6LUkIVJDVmY1JCFSQ1ZmNT4jnNFQqPK7QFgaIwR8qA7jXzdLQE+Grh6c/DarUF+m4VJcL6Q15jUkIVJDVmY1Fi6G/RA2Bedes1v1FK1Saz+5A2lO+TzTwb53UlR2HecK4qMkKWRirFkjbGUkoAwIUsjlZYqlFGYHO6lBqCw8PjbRfwzQIVlfcrMIwqteiXW26tswtQ3gqJMvQLbk6zClHBgS46EjJg75MvBNfaaC7QoQkEROqyRfzLon8hu0JhYAmsDWhOsoAh9kRL/z90O9MVnpoX7HXyEv5W01AJXvxlL12DtRpnI7aF/hfv1eENYG9CqozlhdatoIabusO9Pb4fAccPWBIPW9M3niuZVtFOpis/gV8XDl4HDA5dbq3/aSNakfeWfCPonX7AHnMBwFPuotNmRuaavtbox/gHfkyRajqg+J6xIWWgna/pG/xfiKD6T+OtJt3OojyL0bPYZZCJBZjw69SY58s5OTBQt1xFclZoUoRfSDSzz2b2DsgoUlpQ3Fyq/3N+MJRQbD7Hz8MAeS156z8N8SlWmXtlStfErfbED6Ox8zP8qQbmOAK0tZfmcKzooK9d8FYJWvYIi9EwsgZ2HZ07wVZ7mi8/CipSF+37cmrPbujI6Yz1pGju3rRPnNasvsntjKdVKN+bmyEFZPd5Qd2+Ax4Y2aI8etOXmP1vSjy0OympfEMqx2Mmawo/qC1ce8Kv6+1LuM+JrhSGE9q1tzkpbkVK1q7rx6s1Bnjc/WFUilAIn4bz4u/u8/+7zASEufl3bPOlTnfrDxWVgNpEXzzaJqQpzo+mfCF5/2hWdesPzeztZs7lww462Di6D/b9YRNi1FoK5qo3PTP8z3M+1d68mdLvLWvb+fi9jJDSbyKMHbdDvYnIh6A761dTr3uB/7rAvNZ80llB109b28+6Fquptla3bRQrrXGR3uf7wZeDZxItRJrKa0C0foVLXFW3Q0oYfzKYKS20FqSdEE5ARhNAn7mCQTwoOq4cAAAAASUVORK5CYII=";

        //二维码内容
        String content = qrUrl;
        try {

            ZXingCode zp = new ZXingCode();
            BufferedImage bim = zp.getQR_CODEBufferedImage(content, BarcodeFormat.QR_CODE, 400, 400, zp.getDecodeHintType());
//            //这个是读取本地文件来生成二维码
//            //return zp.addLogo_QRCode(bim, new File(filePath), new LogoConfig(), productName);
//            return zp.addLogo_QRCode(bim, base64Url, new LogoConfig(), productName);

            //生成不带logo的二维码
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ImageIO.write(bim, "png", baos); // 这里使用 "png" 格式，您可以根据实际情况选择其他格式
                //在本地生成二维码图片
//                ImageIO.write(bim, "png", new File("e:/erweima/" + new Date().getTime() + "test.png"));
            } catch (IOException e) {
                e.printStackTrace(); // 处理异常
            }
            byte[] imageBytes = baos.toByteArray();
            return  Base64.getEncoder().encodeToString(imageBytes);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
    * @author: wangmenglong
    * @date; 2024/3/1 11:13
    * @description: 生成带logo的二维码图片
    * @param: [qrUrl, request, productName]
    * @return: java.awt.image.BufferedImage
    **/
    public static BufferedImage getQRCodeImage(String qrUrl) {
        //二维码内容
        String content = qrUrl;
        try {
            ZXingCode zp = new ZXingCode();
            BufferedImage bim = zp.getQR_CODEBufferedImage(content, BarcodeFormat.QR_CODE, 400, 400, zp.getDecodeHintType());
            //这个是读取本地文件来生成二维码
            return bim;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }


    /**
     * base64 编码转换为 BufferedImage
     * @param base64
     * @return
     */
    public  static BufferedImage base64ToBufferedImage(String base64) {
        Base64.Decoder decoder = Base64.getDecoder();
//        BASE64Decoder decoder = new sun.misc.BASE64Decoder();
        try {
            byte[] bytes1 = decoder.decode(base64);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes1);
            return ImageIO.read(bais);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }


    /**
     * 给二维码图片添加Logo * *
     */
    //public String addLogo_QRCode(BufferedImage bim, File logoPic, LogoConfig logoConfig, String productName) {
    public String addLogo_QRCode(BufferedImage bim, String base64, LogoConfig logoConfig, String productName) {
        try {
            /** * 读取二维码图片，并构建绘图对象 */
            BufferedImage image = bim;
            Graphics2D g = image.createGraphics();
            /** * 读取Logo图片 */
            //通过本地文件生成base64
            //BufferedImage logo = ImageIO.read(logoPic);

            BufferedImage logo = base64ToBufferedImage(base64);

            /** * 设置logo的大小,本人设置为二维码图片的20%,因为过大会盖掉二维码 */
            int widthLogo = logo.getWidth(null) > image.getWidth() * 3 / 10 ? (image.getWidth() * 3 / 10) : logo.getWidth(null),
                    heightLogo = logo.getHeight(null) > image.getHeight() * 3 / 10 ? (image.getHeight() * 3 / 10) : logo.getWidth(null);
            /** * logo放在中心 */
            int x = (image.getWidth() - widthLogo) / 2;
            int y = (image.getHeight() - heightLogo) / 2;
            /** * logo放在右下角 * int x = (image.getWidth() - widthLogo); * int y = (image.getHeight() - heightLogo); */
            //开始绘制图片
            g.drawImage(logo, x, y, widthLogo, heightLogo, null);
            // g.drawRoundRect(x, y, widthLogo, heightLogo, 15, 15);
            // g.setStroke(new BasicStroke(logoConfig.getBorder()));
            // g.setColor(logoConfig.getBorderColor());
            // g.drawRect(x, y, widthLogo, heightLogo);
            g.dispose();
            //把商品名称添加上去，商品名称不要太长哦，这里最多支持两行。太长就会自动截取啦
            if (productName != null && !productName.equals("")) {
                //新的图片，把带logo的二维码下面加上文字
                BufferedImage outImage = new BufferedImage(400, 445, BufferedImage.TYPE_4BYTE_ABGR);
                Graphics2D outg = outImage.createGraphics();
                //画二维码到新的面板
                outg.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
                //画文字到新的面板
                outg.setColor(Color.BLACK);
                outg.setFont(new Font("宋体", Font.BOLD, 20)); //字体、字型、字号
                //outg.setFont(new Font(null, Font.BOLD, 20)); //字体、字型、字号
                int strWidth = outg.getFontMetrics().stringWidth(productName);
                if (strWidth > 399) {
                    // //长度过长就截取前面部分
                    // outg.drawString(productName, 0, image.getHeight() + (outImage.getHeight() - image.getHeight())/2 + 5 ); //画文字
                    //长度过长就换行
                    String productName1 = productName.substring(0, productName.length() / 2);
                    String productName2 = productName.substring(productName.length() / 2, productName.length());
                    int strWidth1 = outg.getFontMetrics().stringWidth(productName1);
                    int strWidth2 = outg.getFontMetrics().stringWidth(productName2);
                    outg.drawString(productName1, 200 - strWidth1 / 2, image.getHeight() + (outImage.getHeight() - image.getHeight()) / 2 + 12);
                    BufferedImage outImage2 = new BufferedImage(400, 485, BufferedImage.TYPE_4BYTE_ABGR);
                    Graphics2D outg2 = outImage2.createGraphics();
                    outg2.drawImage(outImage, 0, 0, outImage.getWidth(), outImage.getHeight(), null);
                    outg2.setColor(Color.BLACK);
                    outg2.setFont(new Font("宋体", Font.BOLD, 20)); //字体、字型、字号
                    //outg2.setFont(new Font(null, Font.BOLD, 20)); //字体、字型、字号
                    outg2.drawString(productName2, 200 - strWidth2 / 2, outImage.getHeight() + (outImage2.getHeight() - outImage.getHeight()) / 2 + 5);
                    outg2.dispose();
                    outImage2.flush();
                    outImage = outImage2;
                } else {
                    //修改编码格式，根据linux编码
                    //String fileEncode = System.getProperty("file.encoding");
                    //outg.drawString(new String(productName.getBytes("UTF-8"), fileEncode), 200 - strWidth / 2, image.getHeight() + (outImage.getHeight() - image.getHeight()) / 2 + 12); //画文字
                    //System.out.println("未编译中文字体："+productName);
                    //outg.drawString(productName, 200 - strWidth / 2, image.getHeight() + (outImage.getHeight() - image.getHeight()) / 2 + 12); //画文字

                    //中文转unicode编码 //页面显示的就是\u6d4b\u8bd5\u0035\u0028\u63a5\u7ad9\u4e8c\u7ef4\u7801\u0029  没起作用
                    //String font = gbEncoding(productName);
                    //System.out.println(font);

                    outg.drawString(productName, 200 - strWidth / 2, image.getHeight() + (outImage.getHeight() - image.getHeight()) / 2 + 12); //画文字
                }
                outg.dispose();
                outImage.flush();
                image = outImage;
            }
            logo.flush();
            image.flush();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.flush();
            ImageIO.write(image, "png", baos);
            //二维码生成的路径，但是实际项目中，我们是把这生成的二维码显示到界面上的，因此下面的折行代码可以注释掉
            //可以看到这个方法最终返回的是这个二维码的imageBase64字符串
            //前端用 <img src="data:image/png;base64,${imageBase64QRCode}"/> 其中${imageBase64QRCode}对应二维码的imageBase64字符串
            //ImageIO.write(image, "png", new File("C:/Users/luoguohui/Desktop/TDC-" + new Date().getTime() + "test.png"));

            //这行是我重构的
            Base64.Encoder encoderinterview = Base64.getEncoder();
            String textinterview = encoderinterview.encodeToString(baos.toByteArray());

            //这行是原本的
            //String imageBase64QRCode = Base64.byteArrayToBase64(baos.toByteArray());
            baos.close();
            return textinterview;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 构建初始化二维码 * *
     * @param bm *
     * @return
     */
    public BufferedImage fileToBufferedImage(BitMatrix bm) {
        BufferedImage image = null;
        try {
            int w = bm.getWidth(), h = bm.getHeight();
            image = new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
            for (int x = 0; x < w; x++) {
                for (int y = 0; y < h; y++) {
                    image.setRGB(x, y, bm.get(x, y) ? 0xFF000000 : 0xFFCCDDEE);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return image;
    }

    /**
     * 生成二维码bufferedImage图片 * *
     * @param content * 编码内容 *
     * @param barcodeFormat * 编码类型 *
     * @param width * 图片宽度 *
     * @param height * 图片高度 *
     * @param hints * 设置参数 *
     * @return
     */
    public BufferedImage getQR_CODEBufferedImage(String content, BarcodeFormat barcodeFormat, int width, int height, Map<EncodeHintType, ?> hints) {
        MultiFormatWriter multiFormatWriter = null;
        BitMatrix bm = null;
        BufferedImage image = null;
        try {
            multiFormatWriter = new MultiFormatWriter();
            // 参数顺序分别为：编码内容，编码类型，生成图片宽度，生成图片高度，设置参数
            bm = multiFormatWriter.encode(content, barcodeFormat, width, height, hints);
            int w = bm.getWidth();
            int h = bm.getHeight();
            image = new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
            // 开始利用二维码数据创建Bitmap图片，分别设为黑（0xFFFFFFFF）白（0xFF000000）两色
            for (int x = 0; x < w; x++) {
                for (int y = 0; y < h; y++) {
                    image.setRGB(x, y, bm.get(x, y) ? QRCOLOR : BGWHITE);
                }
            }
        } catch (WriterException e) {
            e.printStackTrace();
        }
        return image;
    }

    /**
     * 设置二维码的格式参数 * *
     * @return
     */
    public Map<EncodeHintType, Object> getDecodeHintType() {
        // 用于设置QR二维码参数
        Map<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        // 设置QR二维码的纠错级别（H为最高级别）具体级别信息
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        // 设置编码方式
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.MARGIN, 0);
        hints.put(EncodeHintType.MAX_SIZE, 350);
        hints.put(EncodeHintType.MIN_SIZE, 100);
        return hints;
    }

    /*
     * 中文转unicode编码
     */
    public static String gbEncoding(final String gbString) {
        char[] utfBytes = gbString.toCharArray();
        String unicodeBytes = "";
        for (int i = 0; i < utfBytes.length; i++) {
            String hexB = Integer.toHexString(utfBytes[i]);
            if (hexB.length() <= 2) {
                hexB = "00" + hexB;
            }
            unicodeBytes = unicodeBytes + "\\u" + hexB;
        }
        return unicodeBytes;
    }

}


