package util;

import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

/**
 * 常用配置
 */
public class ConfigCache {

    /**
     * 数值及状态名
     */
    private static Map<Integer, String> valStateMap;

    /**
     * 状态名及数值
     */
    private static Map<String, Integer> stateValMap;

    private static ConfigCache instance;

    private ConfigCache() {
        valStateMap = new HashMap<>();
        /**
         * 招聘状态取值
         * 报备report 1,状态：上车：bycar 2,到达：arrived 3，面试：interview 4，面试通过：interviewpass 5，入职：entry 6
         */
        valStateMap.put(2, "bycar");
        valStateMap.put(3, "arrived");
        valStateMap.put(4, "interview");
        valStateMap.put(5, "interviewpass");
        valStateMap.put(6, "entry");

        stateValMap = new HashMap<>();
        stateValMap.put("bycar", 2);
        stateValMap.put("arrived", 3);
        stateValMap.put("interview", 4);
    }

    public static ConfigCache getInstance() {
        if (instance == null) {
            instance = new ConfigCache();
        }
        return instance;
    }

    public Map<Integer, String> getValStateMap() {
        return valStateMap;
    }

    public Map<String, Integer> getstateValMap() {
        return stateValMap;
    }

}
