package com.jfb.recruit.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.github.pagehelper.PageInfo;
import com.jfb.recruit.service.ExperienceService;
import data.recruit.Experience;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 招聘类型
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/experience")
public class ExperienceController extends BaseController {

    @Resource
    ExperienceService experienceService;

    /**
     * @description: 获取所有招聘类型列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/all")
    public BaseResult all(HttpServletRequest req, Experience recrutiType){
        PageInit(req);
        List<Experience> list = experienceService.listAll(recrutiType);
        PageInfo<Experience> pageInfo = new PageInfo<Experience>(list);
        return BaseResult.success(pageInfo);
    }



}
