var express = require('express');
var path = require('path');
var cookieParser = require('cookie-parser');
var logger = require('morgan');

const {createProxyMiddleware} = require('http-proxy-middleware');
const history = require('connect-history-api-fallback');
var app = express();

//下面两行代码解决刷新404（加上下面两行代码微信扫码登录不能用）
app.use(history());
app.use(express.static(__dirname+'/public'));
// app.use(express.static(path.join(__dirname, 'public')));


var param = process.argv.splice(2);
var port = param[0];

// 允许所有域名跨域
app.all('*', function (req, res, next) {
    req.header("gray","yes");
    res.header("Access-Control-Allow-Origin", "*");
    res.header("Access-Control-Allow-Headers", "Content-Type,Content-Length, Authorization, Accept,X-Requested-With");
    res.header("Access-Control-Allow-Methods", "PUT,POST,GET,DELETE,OPTIONS");
    res.header("X-Powered-By", ' 3.2.1');
    res.header("gray", ' yes');

    console.log("=============prod123");
    // 跨域请求CORS中的预请求
    if (req.method == "OPTIONS") {
        // res.send(200); //让options请求快速返回
    } else {
        next();
    }
});

app.use('/djl-account',
    createProxyMiddleware({
        target: "http://djl-account",
        changeOrigin: true,
        pathRewrite: {
            "^/djl-account": "/"
        }
    }));


app.use('/djl-archives',
    createProxyMiddleware({
        target: "http://djl-archives",
        changeOrigin: true,
        pathRewrite: {
            "^/djl-archives": "/"
        }
    }));

app.use('/djl-attendance',
    createProxyMiddleware({
        target: "http://djl-attendance",
        changeOrigin: true,
        pathRewrite: {
            "^/djl-attendance": "/"
        }
    }));

app.use('/djl-auth',
    createProxyMiddleware({
        target: "http://djl-auth",
        changeOrigin: true,
        pathRewrite: {
            "^/djl-auth": "/"
        }
    }));

app.use('/djl-contract',
    createProxyMiddleware({
        target: "http://djl-contract",
        changeOrigin: true,
        pathRewrite: {
            "^/djl-contract": "/"
        }
    }));

app.use('/djl-message',
    createProxyMiddleware({
        target: "http://djl-message",
        changeOrigin: true,
        pathRewrite: {
            "^/djl-message": "/"
        }
    }));

app.use('/djl-oss',
    createProxyMiddleware({
        target: "http://djl-oss",
        changeOrigin: true,
        pathRewrite: {
            "^/djl-oss": "/"
        }
    }));

app.use('/djl-project',
    createProxyMiddleware({
        target: "http://djl-project",
        changeOrigin: true,
        pathRewrite: {
            "^/djl-project": "/"
        }
    }));

app.use('/djl-recruit',
    createProxyMiddleware({
        target: "http://djl-recruit",
        changeOrigin: true,
        pathRewrite: {
            "^/djl-recruit": "/"
        }
    }));

app.use('/djl-role',
    createProxyMiddleware({
        target: "http://djl-role",
        changeOrigin: true,
        pathRewrite: {
            "^/djl-role": "/"
        }
    }));

app.use('/djl-salary',
    createProxyMiddleware({
        target: "http://djl-salary",
        changeOrigin: true,
        pathRewrite: {
            "^/djl-salary": "/"
        }
    }));

app.use('/djl-settlement',
    createProxyMiddleware({
        target: "http://djl-settlement",
        changeOrigin: true,
        pathRewrite: {
            "^/djl-settlement": "/"
        }
    }));

app.listen(port);
